/*!Copyright(c) 2010-2014 Shenzhen TP-LINK Technologies Co.Ltd.
 *
 *\file     log.h
 *\brief    
 *
 *\author   liang liang
 *\version  1.0.0
 *\date     2014-07-05
 *
 *\history 
 *                  
 *          \arg 1.0.0, 2014-07-05, liang liang, Create the file.
 */


#ifndef __LOG_H_
#define __LOG_H_

#include "os_dep.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

extern int g_mc_debug;

os_s32 init_log(void);
void log_format(char* cmd, ...);

#define log_info(fmt, args...) do { \
    if (g_mc_debug >= 1)\
        log_format("msgcenterd[%s:%d]: " fmt "\n", __func__, __LINE__, ## args); \
} while (0)


#define log_err(fmt, args...) do { \
        log_format("msgcenterd[%s:%d]: " fmt "\n", __func__, __LINE__, ## args); \
} while (0)



#define log_debug(fmt, args...) do { \
    if (g_mc_debug >= 5)\
        log_format("msgcenterd[%s:%d]: " fmt "", __func__, __LINE__, ## args); \
} while (0)


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __LOG_H_ */

